IF EXISTS (SELECT * FROM sys.objects WHERE  object_id = OBJECT_ID(N'P_EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS_SINTETICO') AND type IN(N'P', N'PC')
)
	DROP PROCEDURE P_EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS_SINTETICO
GO

CREATE PROCEDURE P_EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS_SINTETICO (@CD_EMP INT, @CD_FILIAL VARCHAR(MAX), @DT_INICIO DATETIME, @DT_FIM DATETIME)
AS
BEGIN

	

	SELECT 
		P.CD_EMP
		,P.CD_FILIAL
		,P.CD_NF
		,ENT.NR_NF
		,ENT.DT_ENT DATA_ENTRADA,
		CASE WHEN OP.TP_MOV = 10 THEN 'ENTRADA TRANSFERNCIA' 
			 WHEN OP.TP_MOV = 0 THEN 'ENTRADA COMPRAS'
		ELSE DS.DS_MOV END AS TIPO_ENTRADA , 
		P.CD_PROD,
		PRD.DS_PROD,
		SUM(P.VLR_ICMS_ST_DARE) AS VLR_ICMS_ST_DARE_ENT,
		SUM(P.VLR_ICMS_EFETIVO)  AS VLR_ICMS_EFETIVO_ENT, 
		SUM(P.VLR_ICMS_SUBS) AS VLR_ICMS_SUBS_ENT, 
		SUM(P.VLR_ICMS_RET) AS VLR_ICMS_RET_ENT,
		SUM(P.VLR_FECOP) AS VLR_FECOP_ENT,
		SUM(P.VLR_FECOP_RET) AS VLR_FECOP_RET_ENT,
		SUM(P.VLR_FECOP_ST) AS VLR_FECOP_ST_ENT,
		SUM(ISNULL(Utilizado.VLR_ICMS_ST_DARE,0)) AS VLR_ICMS_ST_DARE_SAI,  
		SUM(ISNULL(Utilizado.VLR_ICMS_EFETIVO,0))  AS VLR_ICMS_EFETIVO_SAI, 
		SUM(ISNULL(Utilizado.VLR_ICMS_SUBS,0)) AS VLR_ICMS_SUBS_SAI, 
		SUM(ISNULL(Utilizado.VLR_ICMS_RET,0)) AS VLR_ICMS_RET_SAI,
		SUM(ISNULL(Utilizado.VLR_FECOP,0)) AS VLR_FECOP_SAI,
		SUM(ISNULL(Utilizado.VLR_FECOP_RET,0)) AS VLR_FECOP_RET_SAI,
		SUM(ISNULL(Utilizado.VLR_FECOP_ST,0)) AS VLR_FECOP_ST_SAI,
		SUM(ISNULL(Devolvido.VLR_ICMS_ST_DARE,0)) AS VLR_ICMS_ST_DARE_DEV,  
		SUM(ISNULL(Devolvido.VLR_ICMS_EFETIVO,0))  AS VLR_ICMS_EFETIVO_DEV, 
		SUM(ISNULL(Devolvido.VLR_ICMS_SUBS,0)) AS VLR_ICMS_SUBS_DEV, 
		SUM(ISNULL(Devolvido.VLR_ICMS_RET,0)) AS VLR_ICMS_RET_DEV,
		SUM(ISNULL(Devolvido.VLR_FECOP,0)) AS VLR_FECOP_DEV,
		SUM(ISNULL(Devolvido.VLR_FECOP_RET,0)) AS VLR_FECOP_RET_DEV,
		SUM(ISNULL(Devolvido.VLR_FECOP_ST,0)) AS VLR_FECOP_ST_DEV,
		SUM(P.VLR_ICMS_ST_DARE - ISNULL(Utilizado.VLR_ICMS_ST_DARE,0) - ISNULL(Devolvido.VLR_ICMS_ST_DARE,0)) AS VLR_ICMS_ST_DARE_SLD,  
		SUM(P.VLR_ICMS_EFETIVO -ISNULL(Utilizado.VLR_ICMS_EFETIVO,0)  -ISNULL(Devolvido.VLR_ICMS_EFETIVO,0))  AS VLR_ICMS_EFETIVO_SLD, 
		SUM(P.VLR_ICMS_SUBS - ISNULL(Utilizado.VLR_ICMS_SUBS,0)  - ISNULL(Devolvido.VLR_ICMS_SUBS,0)) AS VLR_ICMS_SUBS_SLD, 
		SUM(P.VLR_ICMS_RET - ISNULL(Utilizado.VLR_ICMS_RET,0) - ISNULL(Devolvido.VLR_ICMS_RET,0)) AS VLR_ICMS_RET_SLD,
		SUM(P.VLR_FECOP - ISNULL(Utilizado.VLR_FECOP,0) - ISNULL(Devolvido.VLR_FECOP,0)) AS VLR_FECOP_SLD,
		SUM(P.VLR_FECOP_RET - ISNULL(Utilizado.VLR_FECOP_RET,0) - ISNULL(Devolvido.VLR_FECOP_RET,0)) AS VLR_FECOP_RET_SLD,
		SUM(P.VLR_FECOP_ST - ISNULL(Utilizado.VLR_FECOP_ST,0) - ISNULL(Devolvido.VLR_FECOP_ST,0)) AS VLR_FECOP_ST_SLD
	FROM EST_PROD PRD
	INNER JOIN EST_NF_ENT_CREDITO_ICMS_ST_PIS_COFINS P ON PRD.CD_PROD = P.CD_PROD
	INNER JOIN EST_NF_ENT_IT IT ON IT.CD_NF = P.CD_NF
									AND IT.CD_FILIAL = P.CD_FILIAL
									AND IT.CD_EMP = P.CD_EMP
									AND IT.CD_PROD = P.CD_PROD
	INNER JOIN EST_NF_ENT ENT ON IT.CD_NF = ENT.CD_NF
								AND IT.CD_FILIAL = ENT.CD_FILIAL
								AND IT.CD_EMP = ENT.CD_EMP
	INNER JOIN GLB_MOV_OP OP ON OP.CD_MOV_OP = ENT.CD_NT_MOV
	INNER JOIN GLB_MOV_OP_TP_MOV DS ON DS.TP_MOV = OP.TP_MOV
	OUTER APPLY (SELECT SUM(QT_IT) AS QT_IT_UTILIZADO
						,SUM(MOV.VLR_ICMS_ST_DARE * MOV.QT_IT) AS VLR_ICMS_ST_DARE
						,SUM(MOV.VLR_ICMS_EFETIVO * MOV.QT_IT)  AS VLR_ICMS_EFETIVO
						,SUM(MOV.VLR_ICMS_SUBS * MOV.QT_IT) AS VLR_ICMS_SUBS
						,SUM(MOV.VLR_ICMS_RET * MOV.QT_IT) AS VLR_ICMS_RET
						,SUM(MOV.VLR_FECOP * MOV.QT_IT) AS VLR_FECOP
						,SUM(MOV.VLR_FECOP_RET * MOV.QT_IT) AS VLR_FECOP_RET
						,SUM(MOV.VLR_FECOP_ST * MOV.QT_IT) AS VLR_FECOP_ST
				 FROM EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV
				 WHERE MOV.CD_EMP = P.CD_EMP
				 AND MOV.CD_FILIAL = P.CD_FILIAL
				 AND MOV.CD_PROD = P.CD_PROD
				 AND MOV.CD_NF_ENT_CRED = P.CD_NF
				 AND MOV.[STATUS] IN (0, 1) /*Confirmado, Reservado e Estornado*/) Utilizado
	OUTER APPLY (SELECT SUM(QT_IT) AS QT_IT_UTILIZADO
						,SUM(MOV.VLR_ICMS_ST_DARE * MOV.QT_IT) AS VLR_ICMS_ST_DARE
						,SUM(MOV.VLR_ICMS_EFETIVO * MOV.QT_IT)  AS VLR_ICMS_EFETIVO
						,SUM(MOV.VLR_ICMS_SUBS * MOV.QT_IT) AS VLR_ICMS_SUBS
						,SUM(MOV.VLR_ICMS_RET * MOV.QT_IT) AS VLR_ICMS_RET
						,SUM(MOV.VLR_FECOP * MOV.QT_IT) AS VLR_FECOP
						,SUM(MOV.VLR_FECOP_RET * MOV.QT_IT) AS VLR_FECOP_RET
						,SUM(MOV.VLR_FECOP_ST * MOV.QT_IT) AS VLR_FECOP_ST
				 FROM EST_NF_ENT_ENTRADA_ICMS_ST_MOV MOV
				 WHERE MOV.CD_EMP = P.CD_EMP
				 AND MOV.CD_FILIAL = P.CD_FILIAL
				 AND MOV.CD_PROD = P.CD_PROD
				 AND MOV.CD_NF_ENT_CRED = P.CD_NF
				 AND MOV.[STATUS] IN (3) /*Confirmado, Reservado e Estornado*/) Devolvido

	WHERE P.CD_FILIAL IN (SELECT DISTINCT ITEM
							FROM dbo.UFD_STRING_SPLIT(@CD_FILIAL, ','))
	AND P.CD_EMP = @CD_EMP
	AND CONVERT(DATE,ENT.DT_ENT) BETWEEN @DT_INICIO AND @DT_FIM
	GROUP BY P.CD_EMP, P.CD_NF, P.CD_FILIAL, ENT.NR_NF ,ENT.DT_ENT, DS.DS_MOV, OP.TP_MOV, P.CD_PROD, PRD.DS_PROD
	ORDER BY P.CD_NF ASC
END